<?php
/*
Plugin Name: Contact Form 7 integration with Kommo/amoCRM
Description: The plugin allows you to set up data transfer from Contact Form 7 to Kommo.
Version: 1.0
Requires Plugins: contact-form-7
Author: crmapp.store
Author URI: https://crmapp.store
*/

if (!defined('ABSPATH')) {
    exit;
}

if (!class_exists('cf7_amocrm')) {
    class cf7_amocrm {
        
		const PLUGIN_NAME = 'Contact Form 7';
        const PLUGIN_KEY = 'cf7';
        const PLUGIN_KEY_URL = 'contact-form-7-wordpress';
		const PAGE_ID = 'cf7_amocrm';
		const ACTION = 'CF7V4';
		const HOST = 'https://devamo.ru/cf7/ajax';
		const PROXY = 'https://functions.yandexcloud.net/d4ek9e15tnll0dcuakaq';
		const CURL_TIMEOUT = 10;
		const LANGS = ['ru', 'en', 'pt', 'es'];
		const CURRENT_VERSION = '20250620';

		private $forms = [];
		private $lang;

		private static $locale;
		private static $translate;

        // Конструктор
        public function __construct() {
			// Инициализация хуков WordPress
            add_action('init', [$this, 'save_utm_to_cookie']);
            add_action('admin_menu', [$this, 'add_admin_menu']);
            add_action('admin_enqueue_scripts', [$this, 'add_scripts'], 11);

			// Хук формы Elementor
			add_action('wpcf7_before_send_mail', [$this, 'send_complete'], 10, 3 );

			// AJAX действия
			add_action('wp_ajax_export_'.self::PLUGIN_KEY, [$this, 'export_lead']);
			add_action('wp_ajax_delete_lead_'.self::PLUGIN_KEY, [$this, 'delete_lead']);

			// Локализация
			add_filter('all_plugins', [$this, 'translate_name_description']);
			$this->initialize_language();
        }

		private function initialize_language() {
			$locale = explode('_', get_locale())[0];

			if (!in_array($locale, self::LANGS, true)) {
				$locale = 'en';
			}

			self::$locale = $locale;

			$langs = require __DIR__ . '/langs.php';
			$this->lang = $langs[$locale] ?? [];
			self::$translate = $this->lang;
		}

		public function translate($key) {
			if (!isset($this->lang[$key])) {
				return $key; // Возврат ключа по умолчанию при отсутствии перевода
			}

			$translation = $this->lang[$key];

			return is_array($translation) ? $translation : str_replace('{PLUGIN_NAME}', self::PLUGIN_NAME, $translation);
		}



		// отправляет в амо
		public function send_complete($record, $handler, $fields_data) {

			$form_id = $_POST['_wpcf7'];
			$post_id = $_POST['_wpcf7_container_post']; 
			$form_fields = get_post_meta( $form_id, self::PLUGIN_KEY.'_form', 1 ); // настройки формы

			if( isset($form_fields['status']) and $form_fields['status'] ){
				$settings = get_option(self::PLUGIN_KEY.'_settings');
				if(!isset($settings['ym_counter'])){
					$settings = ['ym_counter' => ''];
				}
				date_default_timezone_set('UTC');
				$amocrm = get_option(self::PLUGIN_KEY.'_amocrm');
				$field_types = $amocrm['field_types'];
				$utms = isset($amocrm['utm_fields']) ? $amocrm['utm_fields'] : false;
				$responsible_user_id = $this->responsible_user_id($form_id, $post_id);
				$lead_name = $form_fields['lead_name'];
				$note = $form_fields['note'];
				$task_text = $form_fields['task']['task_text'];
				$current_datetime = date('Y-m-d H:i:s');
		
				$form_data = $fields_data->get_posted_data();  // пришло в форму

				$form_name = get_the_title($form_id);
				$page_name = get_the_title($post_id);
				$page_url = get_option('home').'?p='.$post_id;
				$home_url = get_option('home');

				$ip = $this->get_ip();
				$os = $this->get_os($_SERVER['HTTP_USER_AGENT']);
				$browser = $this->get_browser($_SERVER['HTTP_USER_AGENT']);
				$screen = isset($_COOKIE['screen']) ? $_COOKIE['screen'] : $this->translate('not_defined');
										
				foreach(array_keys($this->translate('system_fields_arr')) as $custom_tag){
					$lead_name = str_replace('{{'.$custom_tag.'}}', ${$custom_tag}, $lead_name);
					$note = str_replace('{{'.$custom_tag.'}}', ${$custom_tag}, $note);
					$custom_tag_value = $form_fields['custom_tags'][$custom_tag];
			
					if($custom_tag_value !== '0' and $custom_tag_value !== ''){
						$_data = explode('-', $custom_tag_value);
						$entity = $_data['0'];
						if( $entity === '' or $entity === null ){
							continue;
						}
						$field_id = $_data['1'];
						$field_type = 'text';
						if(isset($field_types[$entity][$field_id])){
							$field_type = $field_types[$entity][$field_id];
						}
			
						if( in_array($field_type, ['date_time', 'birthday', 'date']) ){
							$form_value = strtotime(${$custom_tag});
						}elseif( in_array($field_type, ['checkbox']) ){
							$form_value = ${$custom_tag} ? true : false;
						}else{
							$form_value = (string)${$custom_tag};
						}
			
						if($form_value === '' or $form_value === null){
							continue;
						}
						
						if($field_id === 'price'){
							$form_value = (int)$form_value;
						}
			
						if( in_array($field_id, ['price', 'name', 'first_name', 'last_name']) ){
							$entities[$entity][$field_id] = $form_value;
						}else{
			
							if(is_array(${$custom_tag})){
								$values = [];
								foreach(${$custom_tag} as $fv){
									$values[] = ['value' => $fv];
								}
								$entities[$entity]['custom_fields_values'][] = [
									'field_id' => (int)$field_id,
									'values' => $values
								];
							}else{
								$entities[$entity]['custom_fields_values'][] = [
									'field_id' => (int)$field_id,
									'values' => [
										[
											'value' => $form_value
										]
									]
								];
							}
						}
					}
				}

				if( $attachments_data = $fields_data->uploaded_files() ){
					$wp_upload_dir = wp_upload_dir();
					$base_upload_dir = $wp_upload_dir['basedir'];
					$base_upload_url = $wp_upload_dir['baseurl'];

					$upload_dir = $base_upload_dir.'/cf7_amocrm/';
                    if(!is_dir($upload_dir)){
                        mkdir($upload_dir, 0775, true);
                    }				

					foreach($attachments_data as $field_file){
						if(is_array($field_file)){
							foreach($field_file as $file_path){
								$file_info = pathinfo($file_path);
								$new_file = $upload_dir.$file_info['basename'];
								if( !copy($file_path, $new_file) ){
									unset($form_data[$name]);
								}else{
									$entities['files'][] = $wp_upload_dir['baseurl'].'/cf7_amocrm/'.$file_info['basename'];
								}
							}
						}

					}
				}
				
				foreach($form_data as $form_field => $form_field_value){
					$key = isset($form_fields['fields'][$form_field]) ? $form_fields['fields'][$form_field] : false;
					if($key !== false and $key != '0'){
						$_data = explode('-', $key);
						$entity = $_data['0'];
						if( $entity === '' or $entity === null ){
							continue;
						}
						$field_id = $_data['1'];
			
						$field_type = 'text';
			
						if(isset($field_types[$entity][$field_id])){
							$field_type = $field_types[$entity][$field_id];
						}
		
						if( in_array($field_type, ['date_time', 'birthday', 'date']) ){
							$form_value = strtotime($form_field_value);
						}elseif( in_array($field_type, ['checkbox']) ){
							$form_value = $form_field_value ? true : false;
						}elseif(is_array($form_field_value)){
							$form_value = implode(' ', $form_field_value);
						}else{
							$form_value = (string)$form_field_value;
						}
			
						if($form_value === '' or $form_value === null){
							continue;
						}
		
						if($field_id === 'price'){
							$form_value = (int)$form_value;
						}
			
						if( in_array($field_id, ['price', 'name', 'first_name', 'last_name']) ){
							$entities[$entity][$field_id] = $form_value;
						}else{
							if( in_array($field_type, ['checkbox']) ){
								$entities[$entity]['custom_fields_values'][] = [
									'field_id' => (int)$field_id,
									'values' => [
										[
											'value' => $form_value
										]
									]
								];
							}elseif(is_array($form_field_value)){
								$values = [];
								foreach($form_field_value as $fv){
									$values[] = ['value' => $fv];
								}
								$entities[$entity]['custom_fields_values'][] = [
									'field_id' => (int)$field_id,
									'values' => $values
								];
							}else{
								$entities[$entity]['custom_fields_values'][] = [
									'field_id' => (int)$field_id,
									'values' => [
										[
											'value' => $form_value
										]
									]
								];
							}
						}
					}

					
		
					if(is_array($form_field_value)){
						$form_field_value = implode(', ', $form_field_value);
					}

					if(is_string($form_field_value)){
						$note = str_replace('{{'.$form_field.'}}', $form_field_value, $note);
						$lead_name = str_replace('{{'.$form_field.'}}', $form_field_value, $lead_name);     
						$task_text = str_replace('{{'.$form_field.'}}', $form_field_value, $task_text);
		
						if($form_fields['tags']){
							foreach($form_fields['tags'] as $key => $tag){
								$form_fields['tags'][$key] = str_replace('{{'.$form_field.'}}', $form_field_value, $tag);
							}
						}
					}				

				}
			
				if($utms){
					$ym_counter_field_id = 0;
					foreach($utms as $field_id => $utm){
						if (isset($_COOKIE[$utm])) {
							$entities['lead']['custom_fields_values'][] = [
								'field_id' => (int)$field_id,
								'values' => [
									[
										'value' => (string)$_COOKIE[$utm]
									]
								]
							];
						}
						if($utm === '_ym_counter'){
							$ym_counter_field_id = $field_id;
						}
					}
		
					if( $ym_counter_field_id and $settings['ym_counter'] ){
						$entities['lead']['custom_fields_values'][] = [
							'field_id' => (int)$ym_counter_field_id,
							'values' => [
								[
									'value' => (string)$settings['ym_counter']
								]
							]
						];
					}
				}
		
				$entities['task'] = [];
				if( $form_fields['task']['task_status'] == 1 ){
					$task_type = $form_fields['task']['task_type'];
					
					foreach(array_keys($this->translate('system_fields_arr')) as $custom_tag){
						$task_text = str_replace('{{'.$custom_tag.'}}', ${$custom_tag}, $task_text);
					}
		
					$task_complete_till = $form_fields['task']['task_complete_till'];
					$task_complete_till_times = $form_fields['task']['task_complete_till_times'];
					$task_complete_till = strtotime($current_datetime . ' +' . $task_complete_till . ' ' . $task_complete_till_times );
					
					$entities['task'] = [
						'responsible_user_id' => (int)$responsible_user_id,
						'task_type_id' => (int)$task_type,
						'text' => $task_text,
						'complete_till' => $task_complete_till,
						'duration' => 1800,
					];
				}
		
				$pipeline_id = (int)$form_fields['pipeline_id'];
				$p_status = $form_fields['p_status'];
				$price = $form_fields['price'];
		
				$entities['lead']['name'] = $lead_name;
		
				$unsortered = strpos($p_status, 'unsortered_');
		
				if($pipeline_id){
					$entities['lead']['pipeline_id'] = $pipeline_id;
				}
		
				// если разобранное
				$entities['lead']['status_id'] = (int)$p_status;
				$entities['lead']['pipeline_id'] = $pipeline_id;       
				$entities['lead']['responsible_user_id'] = (int)$responsible_user_id;
		
				if($price){
					$entities['lead']['price'] = (int)$price;
				}           
		
				if($form_fields['tags']){
					foreach($form_fields['tags'] as $tag){
						if(empty($tag)){
							continue;
						}
						foreach(array_keys($this->translate('system_fields_arr')) as $custom_tag){
							$tag = str_replace('{{'.$custom_tag.'}}', ${$custom_tag}, $tag);
						}
						$entities['lead']['tags_to_add'][] = ['name' => (string)$tag];
					}
				}
		
				if(isset($entities['contact'])){
					$entities['contact']['responsible_user_id'] = (int)$responsible_user_id;
				}
		
				if(isset($entities['company'])){
					$entities['company']['responsible_user_id'] = (int)$responsible_user_id;
				}
		
				$entities['note'] = $note;
				$entities['ip'] = $ip;
		
				if(isset($form_fields['salesbot']) and (int)$form_fields['salesbot']['status'] and (int)$form_fields['salesbot']['id']){
					$entities['salesbot'] = $form_fields['salesbot']['id'];
				}
		
				// неразобранное
				if($unsortered !== false){
					$entities['lead']['request_id'] = (string)time();
					$entities['lead']['source_name'] = get_option('blogname');
					$entities['lead']['source_uid'] = md5(microtime(true).'devamo.ru');
					$entities['lead']['_embedded']['metadata'] = [ 
						'ip' => $ip,
						'form_id' => $form_id,
						'form_sent_at' => (int)time(),
						'form_name' => $form_name,
						'form_page' => $page_url,
						'referer' => $_SERVER['HTTP_REFERER'] ? $_SERVER['HTTP_REFERER'] : $_SERVER['HTTP_HOST'],
						'category' => 'forms',
					];
					if($pipeline_id){
						$entities['lead']['_embedded']['source']['external_id'] = implode('_', [self::PLUGIN_KEY, $pipeline_id]);
						$entities['lead']['_embedded']['source']['type'] = 'widget';
					}
				}

				$entities['antidub'] = $form_fields['antidub'];
				
				$data['action'] = self::ACTION;      
				$data['data'] = json_encode($entities);      
				$data['url'] = $_SERVER['HTTP_HOST'];

				self::send_data($data);	
				$this->save_lead($form_id, $post_id, $entities);
			}
		}

		public function delete_lead(){

			if( !isset($_POST['nonce']) or !wp_verify_nonce( $_POST['nonce'], self::PLUGIN_KEY.'_delete_nonce')){
				echo json_encode(['status' => 0, 'message' => 'Неавторизованный доступ']);
				wp_die();
			}

			if(!isset($_POST['leads_id'])){
				echo json_encode(['status' => 0, 'message' => 'Нет данных']);
				wp_die();
			}

			global $wpdb;
			$table_name = $wpdb->prefix . self::PLUGIN_KEY.'_leads';
			$placeholders = implode(',', array_fill(0, count($_POST['leads_id']), '%d'));
			$wpdb->query($wpdb->prepare(
				'DELETE FROM `'.$table_name.'` WHERE ID IN ('.$placeholders.')',
				$_POST['leads_id']
			));

			echo json_encode(['status' => 1, 'delete' => $_POST['leads_id']]);
			wp_die();
		}

		public function export_lead(){
			if( !isset($_POST['nonce']) or !wp_verify_nonce( $_POST['nonce'], self::PLUGIN_KEY.'_export_nonce')){
				echo json_encode(['status' => 0, 'message' => 'Неавторизованный доступ']);
				wp_die();
			}

			if(!isset($_POST['lead_id'])){
				echo json_encode(['status' => 0, 'message' => 'Нет данных']);
				wp_die();
			}

			$lead = $this->get_lead($_POST['lead_id']);
			$data = $lead['json'];
			$result = self::send_data([
				'url' => $_SERVER['HTTP_HOST'],
				'data' => $data,
				'action' => self::ACTION,
			]);
			echo json_encode($result);
			wp_die();
		}

		// сохраняет отправленные заявки
		public function save_lead($form_id, $post_id, $data){
			$settings = get_option(self::PLUGIN_KEY.'_amocrm');
			$text = [];
			foreach($data as $entity => $entity_value){
				$entity_keys = is_array($entity_value) ? array_keys($entity_value) : false;
				if($entity_keys){
					foreach($entity_keys as $entity_key){
						$value = $entity_value[$entity_key];
						$pipeline_id = isset($data[$entity]['pipeline_id']) ? $data[$entity]['pipeline_id'] : false;

						if( in_array($entity, ['lead', 'contact', 'company']) ){
							switch ($entity_key) {
								case 'name':
									$name = $this->translate('name');
									$text[$entity][0] = $name.': '.$value;
									break;
								case 'responsible_user_id':
									$text[$entity][3] = $this->translate('responsible').': '.(isset($settings['managers'][$value]) ? $settings['managers'][$value] : $this->translate('not_selected'));
									break;
								case 'pipeline_id':
									$text[$entity][1] = $this->translate('pipeline').': '.$settings['pipelines'][$pipeline_id]['name'];
									break;
								case 'status_id':
									if( isset($settings['pipelines'][$pipeline_id]['statuses'][$value]['name']) ){
										$text[$entity][2] = $this->translate('pipeline_status').': '.$settings['pipelines'][$pipeline_id]['statuses'][$value]['name'];
									}
									break;
								case 'price':
									$text[$entity][4] = $this->translate('sale').': '.$value;
									break;
								case 'first_name':
									$text[$entity][0] = $this->translate('first_name').': '.$value;
									break;
								case 'last_name':
									$text[$entity][1] = $this->translate('last_name').': '.$value;
									break;
								case 'tags_to_add':
									if(isset($data['lead']['tags_to_add'])){
										$tags = [];
										foreach($data['lead']['tags_to_add'] as $tag){
											$tags[] = $tag['name'];
										}
										$text[$entity][99] = $this->translate('tags').': '.implode(', ', $tags);
									}
									break;
								case 'custom_fields_values':
									$fields = isset($data[$entity]['custom_fields_values']) ? $data[$entity]['custom_fields_values'] : false;
									if($fields){
										$i = 10;
										foreach($fields as $field){
											$field_name = false;
											$i++;
											if(isset($settings['fields'][$entity.'-'.$field['field_id']])){
												$field_name = $settings['fields'][$entity.'-'.$field['field_id']];
												$field_name = str_replace([
													$this->translate('lead').' :: ',
													$this->translate('contact').' :: ',
													$this->translate('company').' :: '
												], '', $field_name);
												if($field['values']){
													$field_values = [];
													foreach($field['values'] as $field_value){
														$field_values[] = $field_value['value'];
													}
													$text[$entity][$i] = $field_name.': '.implode(', ', $field_values);
												}
											}

											if(isset($settings['utm_fields'][$field['field_id']])){
												$field_name = $settings['utm_fields'][$field['field_id']];
												if($field['values']){
													$field_values = [];
													foreach($field['values'] as $field_value){
														$field_values[] = $field_value['value'];
													}
													$text[$entity][$i] = $field_name.': '.implode(', ', $field_values);
												}
											}
										}
									}
									break;
							}
						}
						
						if($entity === 'task'){
							$task = $data['task'];
							switch ($entity_key) {
								case 'responsible_user_id':
									if( isset($settings['managers'][$task['responsible_user_id']]) ){
										$text[$entity][3] = $this->translate('responsible').': '.$settings['managers'][$task['responsible_user_id']];
									}
									break;
								case 'text':
									$text[$entity][0] = $this->translate('description').': '.$task['text'];
									break;
								case 'complete_till':
									$text[$entity][1] = $this->translate('deadline').': '.date('d.m.Y H:i:s', $task['complete_till']);
									break;
								case 'task_type_id':
									foreach($settings['task_types'] as $task_type){
										if($task['task_type_id'] == $task_type['id']){
											$text[$entity][2] = $this->translate('type').': '.$task_type['name'];
										}
									}
									break;
							}
						}
					}
				}

				if($entity === 'note'){
					$text[$entity] = $entity_value;
				}           
			}

			$content = '';

			if(isset($text['lead'])){
				ksort($text['lead']);
				$content .= '<div>';
				$content .= '<div><b>'.$this->translate('lead').'</b></div>';
				$content .= '<p>'.implode('</p><p>', $text['lead']).'</p>';
				$content .= '</div><br>';
			}

			if(isset($text['contact'])){
				ksort($text['contact']);
				$content .= '<div>';
				$content .= '<div><b>'.$this->translate('contact').'</b></div>';
				$content .= '<p>'.implode('</p><p>', $text['contact']).'</p>';
				$content .= '</div><br>';
			}

			if(isset($text['company'])){
				ksort($text['company']);
				$content .= '<div>';
				$content .= '<div><b>'.$this->translate('company').'</b></div>';
				$content .= '<p>'.implode('</p><p>', $text['company']).'</p>';
				$content .= '</div><br>';
			}

			if(isset($text['task'])){
				ksort($text['task']);
				$content .= '<div>';
				$content .= '<div><b>'.$this->translate('task').'</b></div>';
				$content .= '<p>'.implode('</p><p>', $text['task']).'</p>';
				$content .= '</div><br>';
			}

			if(isset($text['note'])){
				$content .= '<div>';
				$content .= '<div><b>'.$this->translate('note').'</b></div>';
				$content .= '<p>' . str_replace(PHP_EOL, '</p><p>', $text['note']) . '</p>';
				$content .= '</div>';
			}
			
			global $wpdb;
			$table_name = $wpdb->prefix . self::PLUGIN_KEY.'_leads';
			$wpdb->insert( $table_name, [ 
				'post_id' => (int)$post_id,
				'form_id' => (int)$form_id,
				'content' => wp_kses_post($content),
				'json' => wp_json_encode($data, JSON_UNESCAPED_UNICODE | JSON_PRESERVE_ZERO_FRACTION),
			], [ '%d','%d', '%s', '%s' ] );
		}

		public function get_browser($userAgent) {
			$browsers = [
				'Firefox',
				'Opera',
				'Chrome',
				'MSIE',
				'Safari'
			];
			foreach($browsers as $browser){
				if(strpos($userAgent, $browser) !== false) { 
					return $browser;
				}
			}
			return $this->translate('unknown');
		}

		// получает OS
		public function get_os($userAgent) { 
			$os_platform  = "Unknown OS Platform";
			$os_array     =  [
				'/windows nt 10/i'      =>  'Windows 10',
				'/windows nt 6.3/i'     =>  'Windows 8.1',
				'/windows nt 6.2/i'     =>  'Windows 8',
				'/windows nt 6.1/i'     =>  'Windows 7',
				'/windows nt 6.0/i'     =>  'Windows Vista',
				'/windows nt 5.2/i'     =>  'Windows Server 2003/XP x64',
				'/windows nt 5.1/i'     =>  'Windows XP',
				'/windows xp/i'         =>  'Windows XP',
				'/windows nt 5.0/i'     =>  'Windows 2000',
				'/windows me/i'         =>  'Windows ME',
				'/win98/i'              =>  'Windows 98',
				'/win95/i'              =>  'Windows 95',
				'/win16/i'              =>  'Windows 3.11',
				'/macintosh|mac os x/i' =>  'Mac OS X',
				'/mac_powerpc/i'        =>  'Mac OS 9',
				'/linux/i'              =>  'Linux',
				'/ubuntu/i'             =>  'Ubuntu',
				'/iphone/i'             =>  'iPhone',
				'/ipod/i'               =>  'iPod',
				'/ipad/i'               =>  'iPad',
				'/android/i'            =>  'Android',
				'/blackberry/i'         =>  'BlackBerry',
				'/webos/i'              =>  'Mobile'
			];
			foreach ($os_array as $regex => $value){
				if (preg_match($regex, $userAgent)){
					$os_platform = $value;
				}
			}
			return $os_platform;
		}

		// получает ip
		public function get_ip(){
			$client  = isset($_SERVER['HTTP_CLIENT_IP']) ? $_SERVER['HTTP_CLIENT_IP'] : false;
			$forward = isset($_SERVER['HTTP_X_FORWARDED_FOR']) ? $_SERVER['HTTP_X_FORWARDED_FOR'] : false;
			$remote  = isset($_SERVER['REMOTE_ADDR']) ? $_SERVER['REMOTE_ADDR'] : $_SERVER['REMOTE_ADDR'];
			if(filter_var($client, FILTER_VALIDATE_IP)){
				$ip = $client;
			}elseif(filter_var($forward, FILTER_VALIDATE_IP)){
				$ip = $forward;
			}else{
				$ip = $remote;
			}
			return $ip;
		}

		// ответственный
		public function responsible_user_id($form_id){
			$form_fields = get_post_meta( $form_id, self::PLUGIN_KEY.'_form', 1 );
			if( !isset($form_fields['responsible_list']) ){
				return 0;
			}
		
			$responsible_list = $form_fields['responsible_list'];
			$form_fields['current_responsible'] = isset($form_fields['current_responsible']) ? (int)$form_fields['current_responsible'] : 0;
			
			$form_fields['current_responsible']++;
			$form_fields['current_responsible'] = isset($responsible_list[($form_fields['current_responsible'])]) ? ($form_fields['current_responsible']) : 0;
			
			update_post_meta( $form_id, self::PLUGIN_KEY.'_form', $form_fields );
			return (int)$responsible_list[($form_fields['current_responsible'])];
		}
		
		// Страница настроек
		public function plugin_page(){
			// сохраняем настройки формы
			if( isset($_POST['action']) and $_POST['action'] === 'save_form' and isset($_POST['nonce']) and wp_verify_nonce( $_POST['nonce'], self::PLUGIN_KEY.'_form') ){
				$_POST[self::PLUGIN_KEY.'_form']['tags'] = isset($_POST[self::PLUGIN_KEY.'_form']['tags']) ? $_POST[self::PLUGIN_KEY.'_form']['tags'] : [];
				update_post_meta( $_GET['form_id'], self::PLUGIN_KEY.'_form', ($_POST[self::PLUGIN_KEY.'_form']) );
			}

			// сохранем общие настройки плагина
			if( isset($_POST['action']) and $_POST['action'] === 'save_settings' and isset($_POST['nonce']) and wp_verify_nonce( $_POST['nonce'], self::PLUGIN_KEY.'_settings_page') ){
				update_option( self::PLUGIN_KEY.'_settings', $_POST[self::PLUGIN_KEY.'_settings'], 'no' );
			}

			// обновляем данные из amoCRM
			if( isset($_GET['clear']) and $_GET['clear']){
				self::get_amo_fields(1);
			}

			// удалим настройки формы
			if( isset($_GET['clear_form']) and $_GET['clear_form']){
				delete_post_meta( $_GET['form_id'], self::PLUGIN_KEY.'_form' );
			}

			$settings = get_option(self::PLUGIN_KEY.'_settings');
			if(!$settings){
				$settings = [];
			}

			if( !isset($settings['ym_counter']) ){
				$settings['ym_counter'] = '';
			}

			$amocrm = get_option(self::PLUGIN_KEY.'_amocrm');
			if( !$amocrm ){
				$amocrm = self::get_amo_fields();
			}

			$amo_fields = isset($amocrm['fields']) ? $amocrm['fields'] : ['0' => $this->translate('fields_not_loaded')];
			$managers = isset($amocrm['managers']) ? $amocrm['managers'] : ['0' => $this->translate('managers_not_loaded')];

			if( isset($_GET['form_id']) and $_GET['form_id'] ){
				$get_post_meta = get_post_meta( $_GET['form_id'], self::PLUGIN_KEY.'_form', 1 );

				$fields = $get_post_meta ? ($get_post_meta) : [];

				$all_tags = array_keys($this->translate('geo_fields_arr'));
				$all_tags[] = 'order_id';

				$form = $this->get_form($_GET['form_id']);

				$form_data = WPCF7_ContactForm::get_instance( $_GET['form_id'] );
				$form_fields = $form_data->collect_mail_tags();

				if($form_fields){
					foreach($form_fields as $form_field){
						$all_tags[] = $form_field;
					}
				}            
				$pipelines = isset($amocrm['pipelines']) ? $amocrm['pipelines'] : ['0' => ['name' => $this->translate('pipelines_not_loaded')]];
				$task = isset($fields['status']) ? $fields['task'] : $this->translate('task_default');
				$task_types = $amocrm['task_types'];
				$note = isset($fields['note']) ? $fields['note'] : $this->translate('note_default');
				$status = isset($fields['status']) ? $fields['status'] : true;

				$salesbot = isset($fields['salesbot']) ? $fields['salesbot'] : ['status' => 0, 'id' => 0];
				$lead_name = isset($fields['lead_name']) ? $fields['lead_name'] : $this->translate('lead_name_default');
				$price = isset($fields['price']) ? $fields['price'] : 1000;
				$pipeline_id = (!isset($fields['pipeline_id']) and $pipelines ) ? key($pipelines) : $fields['pipeline_id']; 
				$tags = isset($fields['tags']) ? $fields['tags'] : $this->translate('tags_arr');
				$responsible_list = !isset($fields['responsible_list'])  ? [] : $fields['responsible_list'];

				$antidub_fields = isset($amocrm['antidub_fields']) ? $amocrm['antidub_fields'] : [0 => $this->translate('fields_not_loaded')];
				$change_responsible = isset($fields['antidub']['change_responsible']) ? $fields['antidub']['change_responsible'] : 0;
				$ignore = isset($fields['antidub']['ignore']) ? $fields['antidub']['ignore'] : [];
				$antidub_status = isset($fields['antidub']['status']) ? $fields['antidub']['status'] : 0;

				$title = $this->translate('form').' :: '.$form['post_title'];
				$bots = $amocrm['bots'];
				require_once (__DIR__ . '/templates/form_edit.php');
			}elseif( isset($_GET['lead_id']) and $_GET['lead_id'] ){
				$lead = $this->get_lead($_GET['lead_id']);
				$title = $this->translate('lead').' # '.$lead['ID'];
				require_once (__DIR__ . '/templates/lead_view.php');
			}else{
				$forms = $this->get_forms();
				$leads = $this->get_leads();
				$title = $this->translate('general_settings');
				$version = $amocrm['version'];
				require_once (__DIR__ . '/templates/settings_page.php');
			}
		}

		// Форма
		public function get_form($form_id){
			return get_post($form_id, 'ARRAY_A');
		}
		
		// Формы
		public function get_forms(){
			global $wpdb;
			$forms = $wpdb->get_results( "SELECT ID, post_title, post_date, post_content FROM $wpdb->posts WHERE post_type = 'wpcf7_contact_form' AND post_status = 'publish'", 'ARRAY_A' );
			foreach ( $forms as $key => $form ) {
				$forms[$key]['post_date'] = date('d.m.Y H:i', strtotime($form['post_date']));
				unset($forms[$key]['post_content']);
				$this->forms[$form['ID']] = $form;
			}
			return $forms;
		}

		// Лиды
		public function get_leads($limit = 50) {
			global $wpdb;
			$table_name = $wpdb->prefix . self::PLUGIN_KEY.'_leads';
			$query = $wpdb->prepare(
				'SELECT * FROM `' . $table_name . '` ORDER BY ID DESC LIMIT %d',
				$limit
			);
			
			try {
				$leads = $wpdb->get_results($query, ARRAY_A);
				return is_array($leads) ? $leads : [];
			} catch (Exception $e) {
				error_log('Leads fetch error: ' . $e->getMessage());
				return [];
			}
		}

		// Лид
		public function get_lead($id) {
			global $wpdb;
			
			// Валидация ID
			if (!is_numeric($id)) {
				return null;
			}
			$table_name = $wpdb->prefix . self::PLUGIN_KEY.'_leads';
			return $wpdb->get_row(
				$wpdb->prepare(
					'SELECT * FROM `' . $table_name . '` WHERE ID = %d', // %d для числа
					(int) $id // Приведение к целому числу
				),
				ARRAY_A
			);
		}

		// Кол-во лидов формы
		public static function get_leads_count($form_id) {
			global $wpdb;
			$table_name = $wpdb->prefix . self::PLUGIN_KEY.'_leads';
			return $wpdb->get_var(
				$wpdb->prepare(
					'SELECT COUNT(*) FROM `' . $table_name . '` WHERE `form_id` = %s', 
					$form_id
				)
			);
		}
		
        // utm метки
        public function save_utm_to_cookie() {
            $date = time()+3600*24*30;
            $options = get_option(self::PLUGIN_KEY.'_amocrm');
            $utms = isset($options['utm_fields']) ? $options['utm_fields'] : false;
            if($utms){
                foreach($utms as $utm){
                    if(isset($_GET[$utm])){
						setcookie($utm, $_GET[$utm], $date, "/"); 
					}
                }
            }
        }
             
        // Меню в настройках
        public function add_admin_menu() {
			add_menu_page(
                $this->translate('plugin_title'), // page title 
                $this->translate('plugin_menu_name'), 
				'manage_options',
				self::PAGE_ID,
				[$this, 'plugin_page'],
				'dashicons-smiley',
				30
			);
        }
       
        // Получение данных amoCRM
        public static function get_amo_fields($clear_cache = 0){
			$result = self::send_data([
                'action' => 'getAmoCF', 
                'url' => $_SERVER['HTTP_HOST'], 
                'companies' => true, 
                'clear' => $clear_cache,
				'lang' => self::$locale,
            ]);
        	if(isset($result['status']) and $result['status']){
                update_option( self::PLUGIN_KEY.'_amocrm', $result['settings'] );
        	}
        	return isset($result['settings']) ? $result['settings'] : false;
        }

		private static  function send_data($data, $attempt = 0){
			$max_attempts = 2;
			$use_proxy = get_option(self::PLUGIN_KEY.'use_proxy', 0); // по умолчанию 0

			$endpoint = $use_proxy ? self::PROXY : self::HOST;
			$query = $data;

			if ($use_proxy) {
				$query['redirect'] = self::HOST;
			}

            $curl = curl_init();
			curl_setopt_array($curl, [
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_URL => $endpoint,
				CURLOPT_HEADER => false,
				CURLOPT_CUSTOMREQUEST => 'POST',
				CURLOPT_TIMEOUT => self::CURL_TIMEOUT,
				CURLOPT_POSTFIELDS => http_build_query($query),
				CURLOPT_SSL_VERIFYPEER => false,
				CURLOPT_SSL_VERIFYHOST => 2,
			]);
            $json = curl_exec($curl);
			$http_code = curl_getinfo($curl, CURLINFO_HTTP_CODE);
			$error = curl_error($curl);
            curl_close($curl);

			$attempt++;

			// Успешный запрос
			if (!$error && $http_code >= 200 && $http_code < 300) {
				$result = json_decode($json, true);
				if (json_last_error() === JSON_ERROR_NONE) {
					return $result;
				}
				error_log('JSON decode error: ' . json_last_error_msg());
			} else {
				error_log(sprintf(
					'Server Connection Error (Attempt %d/%d, Proxy: %s): %s, HTTP: %d',
					$attempt,
					$max_attempts,
					$use_proxy ? 'Yes' : 'No',
					$error ?: 'No error',
					$http_code
				));
			}

			// Если есть ещё попытки
			if ($attempt < $max_attempts) {
				$new_proxy_setting = !$use_proxy;
				update_option(self::PLUGIN_KEY.'use_proxy', (int)$new_proxy_setting);
				return self::send_data($data, $attempt);
			}

			return false;

		}

        // Активации
        public static function activate() {
            if (!function_exists('curl_version')) {
                deactivate_plugins(plugin_basename(__FILE__), true);
                wp_die(str_replace('{PLUGIN_NAME}', self::PLUGIN_NAME, self::$translate['curl_not_installed']));
            }

			if (!class_exists('WPCF7')) {
                deactivate_plugins(plugin_basename(__FILE__), true);
                wp_die(str_replace('{PLUGIN_NAME}', self::PLUGIN_NAME, self::$translate['plugin_not_installed']));
			}
        
            if( !self::get_amo_fields() ){
                deactivate_plugins(plugin_basename(__FILE__), true);
				wp_die(str_replace('{PLUGIN_NAME}', self::PLUGIN_NAME, self::$translate['site_not_added']));
            }

			global $wpdb;
			$table_name = $wpdb->prefix . self::PLUGIN_KEY.'_leads';
			$sql = 'CREATE TABLE IF NOT EXISTS `' . $table_name . '` (
				`ID` bigint(20) NOT NULL AUTO_INCREMENT,
				`post_id` bigint(20) NOT NULL,
				`form_id` bigint(20) NOT NULL,
				`content` longtext NOT NULL,
				`json` longtext NOT NULL,
				`date` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
				PRIMARY KEY (`ID`),
				KEY `post_id` (`post_id`),
				KEY `form_id` (`form_id`),
				KEY `date` (`date`)
			) ' . $wpdb->get_charset_collate() . ';';
			$wpdb->query($sql);
        }

        // Деактивации
        public static function deactivate() {
            delete_option(self::PLUGIN_KEY.'_amocrm');
            delete_option(self::PLUGIN_KEY.'_settings');
            delete_option(self::PLUGIN_KEY.'use_proxy');
        }

		public function translate_name_description($plugins) {
            $plugin_file = plugin_basename(__FILE__);
			if (isset($plugins[$plugin_file])) {
				$plugins[$plugin_file]['Name'] = $this->translate('Name');
				$plugins[$plugin_file]['Description'] = $this->translate('Description');
				
			}
            return $plugins;
        }

        // Скрипты и стили
        public function add_scripts( $hook_suffix ) {
            if ( strpos( $hook_suffix, self::PAGE_ID ) === false ) {
                return;
            }

            wp_enqueue_script(self::PLUGIN_KEY.'-chosen-js', plugins_url( '/'.self::PLUGIN_KEY.'_amocrm/js/chosen.jquery.min.js' ), '', filemtime( __DIR__ . ('/js/chosen.jquery.min.js') ) ,true);
            wp_enqueue_script(self::PLUGIN_KEY.'-js', plugins_url( '/'.self::PLUGIN_KEY.'_amocrm/js/main.js' ), '', filemtime( __DIR__ . ('/js/main.js') ) ,true);
            
            wp_enqueue_style( self::PLUGIN_KEY.'-chosen-css', plugins_url( '/'.self::PLUGIN_KEY.'_amocrm/css/chosen.min.css' ), null, filemtime( __DIR__ . ('/css/chosen.min.css') ), 'all' );
            wp_enqueue_style( self::PLUGIN_KEY.'-css', plugins_url( '/'.self::PLUGIN_KEY.'_amocrm/css/main.css' ), null, filemtime( __DIR__ . ('/css/main.css') ), 'all' );
        }

    }

    // Инициализация плагина
    $cf7_amocrm_instance = new cf7_amocrm();

    // Регистрация хуков активации и деактивации
    register_activation_hook(__FILE__, ['cf7_amocrm', 'activate']);
    register_deactivation_hook(__FILE__, ['cf7_amocrm', 'deactivate']);
}
