<?php 
    if(isset($_POST['nonce'])){
        $verify_nonce = wp_verify_nonce( $_POST['nonce'], 'customforms-amocrm');
    }
    
    // удаляем кастомную форму
    if( isset($_POST['action']) and $_POST['action'] === 'delete_form' and isset($_POST['nonce']) and $verify_nonce ){
        wp_delete_post($_POST['custom_form_id'], true);
    }

    // удаляем лид
    if( isset($_GET['action']) and $_GET['action'] === 'delete_lead' and isset($_GET['lead_id']) and wp_verify_nonce( $_GET['nonce'], 'customforms-amocrm') ){
        wp_delete_post($_GET['lead_id'], true);
    }

    // сохраняем настройки кастомной формы
    if( isset($_POST['action']) and $_POST['action'] === 'save_custom_form' and isset($_POST['nonce']) and $verify_nonce ){
        $_POST['customforms-amocrm']['tags'] = isset($_POST['customforms-amocrm']['tags']) ? $_POST['customforms-amocrm']['tags'] : [];
        wp_update_post(wp_slash([
            'ID' => $_POST['custom_form_id'],
            'post_title' => $_POST['post_title'],
        ]));
        update_post_meta( $_POST['custom_form_id'], 'customforms-amocrm', ($_POST['customforms-amocrm']) );
    }
       
    // сохранем общие настройки плагина
    if( isset($_POST['action']) and $_POST['action'] === 'save_settings' and isset($_POST['nonce']) and $verify_nonce ){
        update_option( 'customforms-amocrm', $_POST['customforms-amocrm'], 'no' );
    }

    // обновляем данные из amoCRM
    if( isset($_GET['clear']) and $_GET['clear'] ){
        getAmoFields_forms_amocrm();
    }

    require_once (__DIR__ . '/fields_default.php');

    $settings = get_option('customforms-amocrm');
    if(!isset($settings['time_zone']) ){
        $settings['time_zone'] = 'Europe/Moscow';
    }

    $amo_settings = get_option('customforms-amocrm-settings');
    if( !$amo_settings ){
        $amo_settings = getAmoFields_forms_amocrm();
    }

    $amoFields = isset($amo_settings['fields']) ? $amo_settings['fields'] : ['0' => __( 'Fields not loaded', 'customforms-amocrm' )];
    $amoManagers = isset($amo_settings['managers']) ? $amo_settings['managers'] : ['0' => __( 'Managers not loaded', 'customforms-amocrm' )];

    if(isset($_GET['custom_form_id']) and $_GET['custom_form_id']){
        $form = get_post($_GET['custom_form_id'], 'ARRAY_A');
        $get_post_meta = get_post_meta( $_GET['custom_form_id'], 'customforms-amocrm', 1 );
        $fields = $get_post_meta ? ($get_post_meta) : [];
        $post_tags = (isset($fields['post_ID']) and $fields['post_ID'] !== '0') ? $custom_tags : $custom_tags_short;
        $all_tags = array_keys( $post_tags );
        $all_tags[] = 'order_id';
        $form_tags = getFormKeys($_GET['custom_form_id']);

        if($form_tags){
            foreach($form_tags as $form_field){
                $all_tags[] = $form_field;
            }
        }
        $form_fields_value = getFormFieldValues($_GET['custom_form_id']);
        $amoPipelines = isset($amo_settings['pipelines']) ? $amo_settings['pipelines'] : ['0' => ['name' => __( 'Pipelines not loaded', 'customforms-amocrm' )]];
        $fields['task'] = isset($fields['status']) ? $fields['task'] : $task_default;
        $task_types = $amo_settings['task_types'];
        $note = isset($fields['note']) ? $fields['note'] : $note_default;
        $fields['status'] = isset($fields['status']) ? $fields['status'] : true;
        $fields['lead_name'] = isset($fields['lead_name']) ? $fields['lead_name'] : $lead_name_default;
        $fields['price'] = isset($fields['price']) ? $fields['price'] : 1000;
        $fields['pipeline_id'] = (!isset($fields['pipeline_id']) and $amoPipelines ) ? key($amoPipelines) : $fields['pipeline_id']; 
        $fields['responsible_user_id'] = isset($fields['responsible_user_id']) ? $fields['responsible_user_id'] : 0;
        $fields['tags'] = isset($fields['tags']) ? $fields['tags'] : $tags_default;
        $required = isset($fields['required']) ? $fields['required'] : [];
        require_once (__DIR__ . '/custom_form_view.php');
    }elseif( isset($_GET['lead_id']) and $_GET['lead_id'] ){
        $form = get_post($_GET['lead_id'], 'ARRAY_A');
        require_once (__DIR__ . '/lead_view.php');
    }elseif( isset($_GET['testing']) ){
        $testing = testing_forms_amocrm();
        $current_version = get_plugin_data(__DIR__ . '/customforms-amocrm.php')['Version'];
        $version = ( isset($testing['version']) ) ? $testing['version'] : __( 'unknown', 'customforms-amocrm' );
        $auth = (isset($testing['auth']) and $testing['auth']) ? __( 'active', 'customforms-amocrm' ) : __( 'authorization required! Click the "Authorization in amoCRM" button', 'customforms-amocrm' );
        $subscribe = isset($testing['subscribe']) ? __( 'until ', 'customforms-amocrm' ) . date('d.m.Y', $testing['subscribe'] ) : __( 'expired', 'customforms-amocrm' );
        $curl = function_exists('curl_version') ? __( 'installed', 'customforms-amocrm' ) : __( 'not installed', 'customforms-amocrm' );
        require_once (__DIR__ . '/testing.php');
    }elseif( isset($_GET['logs']) ){
        $log = file_get_contents('https://devamo.ru/logs?widget=customforms&url='.$_SERVER['HTTP_HOST']);
        require_once (__DIR__ . '/logs.php');
    }else{
        $forms_custom = get_custom_forms_amocrm();
        $leads = getLeads_forms_amocrm();
        $settings['urls_disabled'] = isset($settings['urls_disabled']) ? $settings['urls_disabled'] : '';
        require_once (__DIR__ . '/settings_page.php');
    }
?>
