<form action="/wp-admin/options-general.php?page=customforms-amocrm&custom_form_id=<?= $form['ID'] ?>" method="post" id="amocrm_wpf">
    <input type="hidden" name="action" value="save_custom_form">
    <input type="hidden" name="nonce" value="<?php echo wp_create_nonce('customforms-amocrm'); ?>">
    <input type="hidden" name="custom_form_id" value="<?= $form['ID'] ?>">
    <div class="wrap">
        <h2 class="aci-title">
            <span><?= $form['post_title'] ?> :: <?php _e( 'Form settings', 'customforms-amocrm' ) ?></span> 
            <a class="button button-order button-large" target="_blank" href="https://devamo.ru/customforms/payurl?url=<?php echo $_SERVER['HTTP_HOST'] ?>"><?php _e( 'Pay for a subscription', 'customforms-amocrm' ) ?></a>
            <a class="button button-auth button-large" target="_blank" href="https://devamo.ru/customforms/button"><?php _e( 'Authorization in amoCRM', 'customforms-amocrm' ) ?></a>
            <a class="button button-red button-large" href="/wp-admin/options-general.php?page=customforms-amocrm&clear=1"><?php _e( 'Update amoCRM data', 'customforms-amocrm' ) ?></a>
            <a class="button button-blue button-large" href="/wp-admin/options-general.php?page=customforms-amocrm&testing"><?php _e( 'Testing', 'customforms-amocrm' ) ?></a>
            <a class="button button-default button-large" href="/wp-admin/options-general.php?page=customforms-amocrm&logs"><?php _e( 'Logs', 'customforms-amocrm' ) ?></a>
        </h2>

        <div class="card" style="max-width:100%">

            <h2 class="title"><?php _e( 'Form settings', 'customforms-amocrm' ) ?></h2>
            <hr>
            <table class="form-table">
		        <tbody>
                    <tr>
                        <th><?php _e( 'Form name', 'customforms-amocrm' ) ?></th>
                        <td>
                            <input type="text" name="post_title" value="<?= $form['post_title'] ?>">
                        </td>
                        <td>
                            <label class="checkbox">
                                <input class="delete_form" type="checkbox" name="form[delete]" value="1"> <span><?php _e( 'Delete form', 'customforms-amocrm' ) ?></span>
                            </label>
                        </td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Page ID', 'customforms-amocrm' ) ?></th>
                        <td>
                            <select name="customforms-amocrm[post_ID]">
                                <option value="0" <?php echo (!isset($fields['post_ID']) or '0' === $fields['post_ID']) ? 'selected' : ''; ?>><?php _e( 'Not selected', 'customforms-amocrm' ) ?></option>
                                <?php if($form_tags){ ?>
                                    <?php foreach($form_tags as $form_tag){ ?>
                                    <option value="<?php echo $form_tag ?>" <?php echo (isset($fields['post_ID']) and $form_tag === $fields['post_ID']) ? 'selected' : ''; ?>><?php echo $form_tag ?></option>
                                    <?php } ?>
                                <?php } ?>
                            </select>
                        </td>
                        <td>
                            <?php _e( 'It is advisable to pass the page ID in the form, otherwise the tags {{page_name}} (page name) and {{page_url}} (link to the page) will not work.', 'customforms-amocrm' ) ?>
                        </td>
                    </tr>

                </tbody>
            </table>

            <h2 class="title"><?php _e( 'Basic', 'customforms-amocrm' ) ?></h2>
            <hr>
            <table class="form-table">
		        <tbody>
                    <tr>
                        <th><?php _e( 'Send to amoCRM', 'customforms-amocrm' ) ?></th>
                        <td>
                            <select name="customforms-amocrm[status]">
                                <option value="1" <?php echo  $fields['status'] ? 'selected' : '' ?> ><?php _e( 'Yes', 'customforms-amocrm' ) ?></option>
                                <option value="0" <?php echo !$fields['status'] ? 'selected' : '' ?> ><?php _e( 'No', 'customforms-amocrm' ) ?></option>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Lead name', 'customforms-amocrm' ) ?></th>
                        <td>
                            <input id="lead_name" type="text" name="customforms-amocrm[lead_name]" value="<?php echo $fields['lead_name'] ?>">
                        </td>
                        <td>
                            <div class="form_tags">
                                <span class="btn-xs btn-outline-primary"><?php echo implode('</span>, <span class="btn-xs btn-outline-primary">', $all_tags) ?></span>
                            </div>
                        </td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Responsible', 'customforms-amocrm' ) ?></th>
                        <td>
                            <select name="customforms-amocrm[responsible_user_id]">
                                <option value="0"><?php _e( 'Not selected', 'customforms-amocrm' ) ?></option>
                                <?php foreach($amoManagers as $manager_id => $manager){ ?>
                                <option value="<?php echo $manager_id ?>" <?php echo $fields['responsible_user_id'] == $manager_id ? 'selected' : ''; ?>><?php echo $manager; ?></option>
                                <?php } ?>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Pipeline', 'customforms-amocrm' ) ?></th>
                        <td>
                            <select id="pipeline_id" name="customforms-amocrm[pipeline_id]">
                                <?php foreach($amoPipelines as $pipeline_id => $pipeline){ ?>
                                    <option value="<?php echo $pipeline_id ?>" <?php echo $fields['pipeline_id'] == $pipeline_id ? 'selected' : ''; ?>><?php echo $pipeline['name']; ?></option>
                                <?php } ?>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Pipeline status', 'customforms-amocrm' ) ?></th>
                        <td><select id="p_status" name="customforms-amocrm[p_status]"></select></td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Price', 'customforms-amocrm' ) ?></th>
                        <td>
                            <input type="number" name="customforms-amocrm[price]" value="<?php echo $fields['price'] ?>" >
                        </td>
                        <td></td>
                    </tr>		
		        </tbody>
		    </table>

            <h2><?php _e( 'Form fields', 'customforms-amocrm' ) ?></h2>
            <hr>
            <table class="form-table">
		        <tbody>

                <?php if($form_tags){ ?>
                    <?php foreach($form_tags as $form_field){ ?>
                        <tr>
                            <th><?= $form_field ?></th>
                            <td>
                                <select name="customforms-amocrm[fields][<?= $form_field ?>]" class="large-text">
                                    <option value="0"><?php _e( 'not selected', 'customforms-amocrm' ) ?></option>
                                    <?php foreach($amoFields as $field_id => $amoField){ ?>
                                    <option value="<?php echo $field_id ?>" <?= (isset($fields['fields'][$form_field]) and $field_id === $fields['fields'][$form_field]) ? 'selected' : '' ?>><?php echo $amoField ?></option>
                                    <?php } ?>
                                </select>
                            </td>
                            <td><?php echo isset($form_fields_value[$form_field]) ? $form_fields_value[$form_field] : '' ?></td>
                            <td><label><input type="checkbox" name="customforms-amocrm[required][]" <?= in_array($form_field, $required) ? 'checked' : '' ?> value="<?= $form_field ?>"><span>Обязательное</span></label></td>
                        </tr>
                    <?php } ?>
                <?php } ?>
                                    
		        </tbody>  
		    </table>

            <h2><?php _e( 'System fields', 'customforms-amocrm' ) ?></h2>
            <hr>
            <table class="form-table">
		        <tbody>

                <?php if($custom_tags){ ?>
                <?php foreach($custom_tags as $custom_tag => $custom_tag_name){ ?>

                    <tr>
                        <th><?= $custom_tag_name ?></th>
                        <td>
                            <select name="customforms-amocrm[custom_tags][<?= $custom_tag ?>]" class="large-text">
                                <option value="0" <?php echo ( isset($fields['custom_tags'][$custom_tag]) and $fields['custom_tags'][$custom_tag] === '0') ? 'selected' : ''; ?>><?php _e( 'Not selected', 'customforms-amocrm' ) ?></option>
                                <?php foreach($amoFields as $field_id => $amoField){ ?>
                                <option value="<?php echo $field_id ?>" <?= (isset($fields['custom_tags'][$custom_tag]) and $field_id === $fields['custom_tags'][$custom_tag]) ? 'selected' : '' ?>><?php echo $amoField ?></option>
                                <?php } ?>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                <?php } ?>
                <?php } ?>
                                    
		        </tbody>  
		    </table>

            <h2><?php _e( 'Tags', 'customforms-amocrm' ) ?></h2>
            <hr>
            <table class="form-table">
		        <tbody>
                <?php if(isset($fields['tags'])){ ?>
                <?php foreach($fields['tags'] as $tag){ ?>
                    <tr>
                        <th></th>
                        <td>
                            <input type="text" name="customforms-amocrm[tags][]" value="<?php echo $tag ?>">
                        </td>
                        <td>
                            <div class="button button-primary button-large removetag"><?php _e( 'Delete', 'customforms-amocrm' ) ?></div>
                        </td>
                    </tr>
                <?php } ?>
                <?php } ?>
                    <tr>
                        <th></th>
                        <td></td>
                        <td>
                            <div class="button button-primary button-large newtag"><?php _e( 'Add', 'customforms-amocrm' ) ?></div>
                        </td>
                    </tr>
		        </tbody>  
		    </table>

            <h2><?php _e( 'Task', 'customforms-amocrm' ) ?></h2>
            <hr>
            <table class="form-table">
		        <tbody>
                    <tr>
                        <th><?php _e( 'Creat task', 'customforms-amocrm' ) ?></th>
                        <td>
                            <select name="customforms-amocrm[task][task_status]" class="large-text">
                                <option value="1" <?php echo  $fields['task']['task_status'] ? 'selected' : ''; ?>><?php _e( 'yes', 'customforms-amocrm' ) ?></option>
                                <option value="0" <?php echo !$fields['task']['task_status'] ? 'selected' : ''; ?>><?php _e( 'no', 'customforms-amocrm' ) ?></option>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Task type', 'customforms-amocrm' ) ?></th>
                        <td>
                            <select name="customforms-amocrm[task][task_type]">
                            <?php foreach($task_types as $task_type){ ?>
                                <option value="<?php echo $task_type['id'] ?>" <?php echo $task_type['id'] == $fields['task']['task_type'] ? 'selected' : ''; ?>><?php echo $task_type['name']; ?></option>
                                <?php } ?>
                            </select>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Task description', 'customforms-amocrm' ) ?></th>
                        <td>
                            <input id="task_text" type="text" name="customforms-amocrm[task][task_text]" value="<?php echo $fields['task']['task_text'] ?>">
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <th><?php _e( 'Deadline tasks via', 'customforms-amocrm' ) ?></th>
                        <td>
                            <input id="task_complete_till" type="text" name="customforms-amocrm[task][task_complete_till]" value="<?php echo $fields['task']['task_complete_till'] ?>">
                        </td>
                        <td>
                            <select name="customforms-amocrm[task][task_complete_till_times]">
                            <?php foreach($times as $time => $time_ru){ ?>
                                <option value="<?php echo $time ?>" <?php echo  $time === $fields['task']['task_complete_till_times'] ? 'selected' : ''; ?>><?php echo $time_ru ?></option>
                            <?php } ?>
                            </select>
                        </td>
                    </tr>

		        </tbody>  
		    </table>

            <h2><?php _e( 'Note', 'customforms-amocrm' ) ?></h2>
            <hr>
            <table class="form-table">
		        <tbody>
                    <tr>
                        <th><?php _e( 'Note template', 'customforms-amocrm' ) ?></th>
                        <td>
                            <textarea id="note" name="customforms-amocrm[note]" rows="15"><?php echo $note ?></textarea>
                        </td>
                        <td>
                            <div><b><?php _e( 'Form fields', 'customforms-amocrm' ) ?></b></div>
                            <div class="form_tags">
                                <span class="btn-xs btn-outline-primary"><?php echo implode('</span>, <span class="btn-xs btn-outline-primary">', $all_tags) ?></span>
                            </div>
                        </td>
                    </tr>
		        </tbody>  
		    </table>
        </div>

        <br>
        <button type="submit" class="button button-primary button-large"><?php _e( 'Save settings', 'customforms-amocrm' ) ?></button>

    </div>
</form>
<script>
    var pipelines = <?php echo json_encode($amoPipelines); ?>;
    var pipeline_id = <?php echo $fields['pipeline_id'] ? $fields['pipeline_id'] : 'false'; ?>;
    var pipeline_status = "<?php echo isset($fields['p_status']) ? $fields['p_status'] : 'false'; ?>";
    var selected_lang = '<?php _e( 'not selected', 'customforms-amocrm' ) ?>';
    var confirm_lang = '<?php _e( 'Are you sure?', 'customforms-amocrm' ) ?>';
</script>