<form action="/wp-admin/options-general.php?page=customforms-amocrm" method="post">
    <input type="hidden" name="action" value="save_settings">
    <input type="hidden" name="nonce" value="<?php echo wp_create_nonce('customforms-amocrm'); ?>">
    <div class="wrap">
        <h2 class="aci-title">
            <span><?php _e( 'Integration with amoCRM', 'customforms-amocrm' ) ?></span> 
            <a class="button button-order button-large" target="_blank" href="https://devamo.ru/customforms/payurl?url=<?php echo $_SERVER['HTTP_HOST'] ?>"><?php _e( 'Pay for a subscription', 'customforms-amocrm' ) ?></a>
            <a class="button button-auth button-large" target="_blank" href="https://devamo.ru/customforms/button"><?php _e( 'Authorization in amoCRM', 'customforms-amocrm' ) ?></a>
            <a class="button button-red button-large" href="/wp-admin/options-general.php?page=customforms-amocrm&clear=1"><?php _e( 'Update amoCRM data', 'customforms-amocrm' ) ?></a>
            <a class="button button-blue button-large" href="/wp-admin/options-general.php?page=customforms-amocrm&testing"><?php _e( 'Testing', 'customforms-amocrm' ) ?></a>
            <a class="button button-default button-large" href="/wp-admin/options-general.php?page=customforms-amocrm&logs"><?php _e( 'Logs', 'customforms-amocrm' ) ?></a>
        </h2>

        <div class="card" style="max-width:100%">
            <h2 class="title"><?php _e( 'My forms', 'customforms-amocrm' ) ?></h2>
            <hr>
            <div class="row">
                <table class="wp-list-table widefat fixed striped table-view-list forms_amocrm">
                    <thead>
                        <tr>
                            <th scope="col" class="manage-column column-name column-primary desc">
                                <span><?php _e( 'Form name', 'customforms-amocrm' ) ?></span>
                            </th>
                            <th scope="col" id="shortcode" class="manage-column column-shortcode"><?php _e( 'leads count', 'customforms-amocrm' ) ?></th>
                            <th scope="col" id="created" class="manage-column column-created desc">
                                <span><?php _e( 'created at', 'customforms-amocrm' ) ?></span>
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($forms_custom){ ?>
                            <?php foreach($forms_custom as $form){ ?>
                            <tr>
                                <td class=" column-name has-row-actions column-primary">
                                    <a href="/wp-admin/options-general.php?page=customforms-amocrm&custom_form_id=<?= $form['ID'] ?>" title="<?php _e( 'Edit form', 'customforms-amocrm' ) ?>">
                                        <strong><?= $form['post_title'] ?></strong>
                                    </a>
                                </td>
                                <td class="shortcode column-shortcode"><?php echo getLeadsByForm_forms_amocrm($form['ID']); ?></td>
                                <td class="created column-created"><?= $form['post_date'] ?></td>
                            </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card" style="max-width:100%">
            <h2 class="title"><?php _e( 'My leads', 'customforms-amocrm' ) ?></h2>
            <hr>
            <div class="row">
                <table class="wp-list-table widefat fixed striped table-view-list forms_amocrm leads_list">
                    <thead>
                        <tr>
                            <th scope="col" class="manage-column column-name column-primary desc">
                                <span>#</span>
                            </th>
                            <th scope="col" id="shortcode" class="manage-column column-shortcode"><?php _e( 'form', 'customforms-amocrm' ) ?></th>
                            <th scope="col" id="created" class="manage-column column-created desc">
                                <span><?php _e( 'created at', 'customforms-amocrm' ) ?></span>
                            </th>
                            <th scope="col" id="action" class="manage-column column-shortcode"><?php _e( 'action', 'customforms-amocrm' ) ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if($leads){ ?>
                            <?php foreach($leads as $lead){ ?>
                            <tr>
                                <td class=" column-name has-row-actions column-primary">
                                    <a href="/wp-admin/options-general.php?page=customforms-amocrm&lead_id=<?= $lead['ID'] ?>" title="<?php _e( 'Edit form', 'customforms-amocrm' ) ?>">
                                        <strong># <?= $lead['ID'] ?></strong>
                                    </a>
                                </td>
                                <td class="shortcode column-shortcode"><a href="/wp-admin/options-general.php?page=customforms-amocrm&custom_form_id=<?= $lead['post_parent'] ?>"><?= get_the_title($lead['post_parent']) ?></a></td>
                                <td class="created column-created"><?= $lead['post_date'] ?></td>
                                <td class="action column-created"> <span data-lead="<?= $lead['ID'] ?>"><?php _e( 'delete', 'customforms-amocrm' ) ?></span></td>
                            </tr>
                            <?php } ?>
                        <?php } ?>
                    </tbody>
                </table>
            </div>
        </div>

        <div class="card" style="max-width:100%">
            <div class="">
                <div class="row">
                    <div class="name">Исключить страницы</div>
                    <div class="value">
                        <textarea name="customforms-amocrm[urls_disabled]" id="" cols="30" rows="10" placeholder="Укажите ID страниц через запятую, на которых не нужно собирать данные из форм"><?php echo $settings['urls_disabled'] ?></textarea>
                    </div>
                    <div class="value"></div>
                </div>
            </div>

		</div>
        <br>
        <button type="submit" class="button button-primary button-large"><?php _e( 'Save settings', 'customforms-amocrm' ) ?></button>

    </div>
</form>
<script>
    var pipelines = 0;
    var pipeline_id = 0;
    var pipeline_status = 0;
    var confirm_lang = '<?php _e( 'Are you sure?', 'customforms-amocrm' ) ?>';
</script>

