<?php
class ControllerExtensionModuleAmocrmIntegration extends Controller {
	private $error = array();

	public function index() {
		$this->load->language('extension/module/amocrm_integration');
		$this->document->setTitle($this->language->get('heading_title'));
		$this->load->model('sale/amocrm_integration');
		$this->load->model('setting/setting');

		$this->document->addStyle('view/stylesheet/chosen.min.css');
		$this->document->addStyle('view/stylesheet/amocrm_integration.css');
		$this->document->addScript('view/javascript/chosen.jquery.min.js');

		$data['tab'] = isset($this->request->get['tab']) ? $this->request->get['tab'] : 'tab-main';

		if (($this->request->server['REQUEST_METHOD'] == 'POST') and $this->validate()) {

			if(isset($this->request->get['refresh'])){
				$this->request->post['module_amocrm_integration']['amo_data'] = $this->getAmoCF();
			}else{
				$this->request->post['module_amocrm_integration']['amo_data'] = $this->config->get('module_amocrm_integration')['amo_data'];
			}

			if( !isset($this->request->post['module_amocrm_integration']['tasks']) ){
				$this->request->post['module_amocrm_integration']['tasks'] = [];
			}

			$this->model_setting_setting->editSetting('module_amocrm_integration', $this->request->post);		
			$this->session->data['success'] = $this->language->get('text_success');
			$this->response->redirect($this->url->link('extension/module/amocrm_integration', 'user_token=' . $this->session->data['user_token'] . '&tab='.$data['tab'], true));
		}

		$data['heading_title'] = $this->language->get('heading_title');
		$data['text_module_status'] = $this->language->get('text_module_status');
		$data['text_edit'] = $this->language->get('text_edit');
		$data['text_enabled'] = $this->language->get('text_enabled');
		$data['text_disabled'] = $this->language->get('text_disabled');
		$data['text_not_loaded'] = $this->language->get('text_not_loaded');
		$data['text_not_selected'] = $this->language->get('text_not_selected');
		$data['text_select'] = $this->language->get('text_select');
		$data['text_no_results'] = $this->language->get('text_no_results');
		$data['text_order'] = $this->language->get('text_order');
		$data['text_client'] = $this->language->get('text_client');
		$data['text_status'] = $this->language->get('text_status');
		$data['text_total'] = $this->language->get('text_total');
		$data['text_added'] = $this->language->get('text_added');
		$data['text_updated'] = $this->language->get('text_updated');
		$data['text_tag_description'] = $this->language->get('text_tag_description');
		$data['text_order_field'] = $this->language->get('text_order_field');
		$data['text_order_field_value'] = $this->language->get('text_order_field_value');
		$data['text_amocrm_field'] = $this->language->get('text_amocrm_field');
		$data['text_last_orders'] = $this->language->get('text_last_orders');
		$data['text_reassign_responsible'] = $this->language->get('text_reassign_responsible');
		$data['text_do_not_overwrite_fields'] = $this->language->get('text_do_not_overwrite_fields');
		$data['text_responsible'] = $this->language->get('text_responsible');
		$data['text_task_type'] = $this->language->get('text_task_type');
		$data['text_task_description'] = $this->language->get('text_task_description');
		$data['text_description'] = $this->language->get('text_description');
		$data['text_deadline'] = $this->language->get('text_deadline');
		$data['text_note_template'] = $this->language->get('text_note_template');
		$data['text_add_link_products'] = $this->language->get('text_add_link_products');
		$data['text_add'] = $this->language->get('text_add');
			
		$data['text_yes'] = $this->language->get('text_yes');
		$data['text_no'] = $this->language->get('text_no');
		$data['text_delete'] = $this->language->get('text_delete');
		
		$data['entry_status'] = $this->language->get('entry_status');
		$data['button_save'] = $this->language->get('button_save');
		$data['button_cancel'] = $this->language->get('button_cancel');
		$data['button_update'] = $this->language->get('button_update');
		
		$data['label_lead_name'] = $this->language->get('label_lead_name');
		
		$data['label_responsible_list'] = $this->language->get('label_responsible_list');
		$data['label_add_products'] = $this->language->get('label_add_products');
		$data['label_pipeline'] = $this->language->get('label_pipeline');
		$data['label_creat_note'] = $this->language->get('label_creat_note');

		$data['tab_main'] = $this->language->get('tab_main');
		$data['tab_sync'] = $this->language->get('tab_sync');
		$data['tab_doubles'] = $this->language->get('tab_doubles');
		$data['tab_builder'] = $this->language->get('tab_builder');
		$data['tab_note'] = $this->language->get('tab_note');
		$data['tab_tasks'] = $this->language->get('tab_tasks');
		$data['tab_tags'] = $this->language->get('tab_tags');
		$data['tab_export'] = $this->language->get('tab_export');
		
		$lang = substr( $this->config->get('config_language'), 0, 2);

		if (isset($this->error['warning'])) {
			$data['error_warning'] = $this->error['warning'];
		} else {
			$data['error_warning'] = '';
		}

		$data['breadcrumbs'] = array();

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_home'),
			'href' => $this->url->link('common/dashboard', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('text_extension'),
			'href' => $this->url->link('extension/module', 'user_token=' . $this->session->data['user_token'] . '&type=module', true)
		);

		$data['breadcrumbs'][] = array(
			'text' => $this->language->get('heading_title'),
			'href' => $this->url->link('extension/module/amocrm_integration', 'user_token=' . $this->session->data['user_token'], true)
		);

		$data['breadcrumbs'][] = array(
			'text' => ' <i class="fa fa-shopping-cart" aria-hidden="true"></i> '.$this->language->get('text_payment'),
			'href' => 'https://devamo.ru/opencart/payurl?lang='.$lang.'&url='.$_SERVER['HTTP_HOST']
		);
		
		$data['action'] = str_replace('&amp;', '&', $this->url->link('extension/module/amocrm_integration', 'user_token=' . $this->session->data['user_token'], true));
		$data['user_token'] = $this->session->data['user_token'];
		$data['cancel'] = $this->url->link('extension/extension', 'user_token=' . $this->session->data['user_token'] . '&type=module', true);

		$note_template = $this->language->get('text_full_name').': {{firstname}} {{lastname}}'.PHP_EOL;
		$note_template .= $this->language->get('text_email').': {{email}}'.PHP_EOL;
		$note_template .= $this->language->get('text_phone').': {{telephone}}'.PHP_EOL . PHP_EOL;
		$note_template .= $this->language->get('text_billing_address').': {{payment_country}}, {{payment_postcode}}, {{payment_city}}, {{payment_zone}}, {{payment_address_1}}, {{payment_address_2}}'.PHP_EOL . PHP_EOL;
		$note_template .= $this->language->get('text_shipping_address').': {{shipping_country}}, {{shipping_postcode}}, {{shipping_city}}, {{shipping_zone}}, {{shipping_address_1}}, {{shipping_address_2}}'.PHP_EOL . PHP_EOL;
		$note_template .= $this->language->get('text_comment').': {{comment}}' . PHP_EOL . PHP_EOL;
		$order_page = isset($this->request->get['page']) ? $this->request->get['page'] : 1;

		$filter_data = [
			'order' => 'DESC',
			'start' => ($order_page - 1) * $this->config->get('config_limit_admin'),
			'limit' => $this->config->get('config_limit_admin'),
			'sort' => 'o.order_id',
		];

		$order_total = $this->model_sale_amocrm_integration->getTotalOrders($filter_data);
		$orders = $this->model_sale_amocrm_integration->getOrders($filter_data);
		$pagination = new Pagination();
		$pagination->total = $order_total;
		$pagination->page = $order_page;
		$pagination->limit = $this->config->get('config_limit_admin');
		$pagination->url = $this->url->link('extension/module/amocrm_integration', 'user_token=' . $this->session->data['user_token'] . '&page={page}', true);

		$data['pagination'] = $pagination->render();
		$data['results'] = sprintf($this->language->get('text_pagination'), ($order_total) ? (($order_page - 1) * $this->config->get('config_limit_admin')) + 1 : 0, ((($order_page - 1) * $this->config->get('config_limit_admin')) > ($order_total - $this->config->get('config_limit_admin'))) ? $order_total : ((($order_page - 1) * $this->config->get('config_limit_admin')) + $this->config->get('config_limit_admin')), $order_total, ceil($order_total / $this->config->get('config_limit_admin')));

		if (isset($this->request->post['module_amocrm_integration'])) {
			$settings = $this->request->post['module_amocrm_integration'];
		} else {
			$settings = $this->config->get('module_amocrm_integration');
		}

		if (isset($this->request->post['module_amocrm_integration_status'])) {
			$data['status'] = $this->request->post['module_amocrm_integration_status'];
		} else {
			$data['status'] = $this->config->get('module_amocrm_integration_status');
		}


		$data['status'] = isset($settings['status']) ? (int)$settings['status'] : 1;
		$data['orders'] = $orders;
		$data['note_status'] = (isset($settings['note_status']) ) ? $settings['note_status'] : 1;
		$data['note_template'] = (isset($settings['note_template']) and $settings['note_template']) ? $settings['note_template'] : $note_template;
		$data['product_link'] = (isset($settings['product_link']) ) ? $settings['product_link'] : 1;	
		$data['lead_name'] = (isset($settings['lead_name']) and $settings['lead_name']) ? $settings['lead_name'] : $this->language->get('label_lead_name_value');	
		$data['sync_statuses'] = (isset($settings['sync_statuses']) and !$settings['sync_statuses']) ? $settings['sync_statuses'] : 1;
		$data['products'] = (isset($settings['products']) and !$settings['products']) ? $settings['products'] : 1;
		$data['sync_comments'] = (isset($settings['sync_comments']) and !$settings['sync_comments']) ? $settings['sync_comments'] : 1; 
		$data['notify_status'] = isset($settings['notify_status']) ? $settings['notify_status'] : 1;
		$data['task_types'] = isset($settings['amo_data']['task_types']) ? $settings['amo_data']['task_types'] : [['id' => 0, 'name' => $this->language->get('text_not_loaded')]];
		$data['task_times'] = [
			'minutes' => $this->language->get('text_minutes'),
			'hours' => $this->language->get('text_hours'),
		];
		
		$task_default[] = [
			'responsible_user_id' => 0,
			'type' => 1,
			'text' => $this->language->get('text_task_description'),
			'deadline' => 24,
			'time' => 'hours'
		];

		$data['tasks'] = isset($settings['tasks']) ? $settings['tasks'] : $task_default;	
		$data['notify_note'] = isset($settings['notify_note']) ? $settings['notify_note'] : 1;
		$data['managers'] = isset($settings['amo_data']['managers']) ? $settings['amo_data']['managers'] : [$this->language->get('text_not_loaded')];
		$data['responsible_user_id'] = isset($settings['responsible_user_id']) ? $settings['responsible_user_id'] : [];
		$data['pipelines'] = isset($settings['amo_data']['pipelines']) ? $settings['amo_data']['pipelines'] : [0 => ['name' => $this->language->get('text_not_loaded')]];
		$data['pipeline_id'] = isset($settings['pipeline_id']) ? $settings['pipeline_id'] : array_keys($data['pipelines'])['0'];
		$data['oc_statuses'] = isset($settings['oc_statuses']) ? $settings['oc_statuses'] : [];
		$data['site_key'] = isset($settings['site_key']) ? $settings['site_key'] : '';
		$data['comparison'] = isset($settings['comparison']) ? $settings['comparison'] : [];

		$data['antidub_status'] = isset($settings['antidub']['status']) ? (int)$settings['antidub']['status'] : 1;
		$data['antidub_ignore'] = isset($settings['amo_data']['antidub_fields']) ? $settings['amo_data']['antidub_fields'] : ['0' => $this->language->get('text_not_loaded')];
		$data['ignore'] = isset($settings['antidub']['ignore']) ? $settings['antidub']['ignore'] : [];
		$data['change_responsible'] = isset($settings['antidub']['change_responsible']) ? $settings['antidub']['change_responsible'] : 0;
		
		$data['tags'] = isset($settings['tags']) ? $settings['tags'] : ['{{store_url}}', 'myshop.ru'];
		$data['fields'] =  isset($settings['amo_data']['fields']) ? $settings['amo_data']['fields'] : [$this->language->get('text_not_loaded')];
		
		$fields = $this->model_sale_amocrm_integration->getSimpleFields();
		$order_fields = explode(',', 'order_id,store_id,store_url,customer,customer_id,customer_group_id,firstname,lastname,email,telephone,fax,payment_firstname,payment_lastname,payment_company,payment_address_1,payment_address_2,payment_city,payment_postcode,payment_country_id,payment_country,payment_zone_id,payment_zone,payment_method,payment_code,shipping_firstname,shipping_lastname,shipping_company,shipping_address_1,shipping_address_2,shipping_city,shipping_postcode,shipping_country_id,shipping_country,shipping_zone,shipping_zone_id,shipping_method,shipping_code,total,coupon,voucher,reward,order_status_id,comment,affiliate_id,affiliate,currency_code,invoice_prefix,invoice_no,date_added,date_modified');
		
		$data['order_fields'] = array_merge($order_fields, $fields);
		$data['order_statuses'] = $this->model_sale_amocrm_integration->getOrderStatuses();
		$data['header'] = $this->load->controller('common/header');
		$data['column_left'] = $this->load->controller('common/column_left');
		$data['footer'] = $this->load->controller('common/footer');
		$this->response->setOutput($this->load->view('extension/module/amocrm_integration', $data));
	}



    private function newOrder($order_id){
        $order_info = $this->getOrder($order_id);
		$order_fields = array_keys($order_info);
        $settings = $this->config->get('module_amocrm_integration');
        $comparison = $settings['comparison'];

		$responsible_user_id = $this->get_responsible_user();

        $lead = [
            'pipeline_id' => (int)$settings['pipeline_id'],
            'status_id' => ( isset($settings['oc_statuses'][$order_info['order_status_id']]) ? (int)$settings['oc_statuses'][$order_info['order_status_id']] : 0 ),
            'responsible_user_id' => (int)$responsible_user_id,
        ];

		if(isset($settings['lead_name']) and $settings['lead_name'] !== ''){
			$lead_name = $settings['lead_name'];
			foreach($order_fields as $order_field){
				if( !is_array($order_info[$order_field]) ){
					$lead_name = str_replace('{{'.$order_field.'}}', $order_info[$order_field], $lead_name);
				}
			}
			$lead['name'] = $lead_name;
		}

		if(isset($settings['tags']) and $settings['tags']){
			foreach($settings['tags'] as $tag){
				foreach($order_fields as $order_field){
					if( !is_array($order_info[$order_field]) ){
						$tag = str_replace('{{'.$order_field.'}}', $order_info[$order_field], $tag);
					}
				}
				$lead['_embedded']['tags'][] = ['name' => (string)$tag];
			}
		}

        
        if($comparison){
			$note_template = $settings['note_status'] ? $settings['note_template'] : '';
            foreach($comparison as $order_field => $amo_field){
				if(!isset($order_info[$order_field])){
					continue;
				}

                if($amo_field !== '0'){
                    $row = explode('-', $amo_field);
                    $entry = $row['0'];
                    $field_id = $row['1'];

                    $order_value = $order_info[$order_field];

					$field_type = 'text';
					if(isset($settings['amo_data']['field_types'][$entry][$field_id])){
						$field_type = $settings['amo_data']['field_types'][$entry][$field_id];
					}
					
					if( in_array($field_type, ['date_time', 'birthday', 'date']) ){
						$order_value = strtotime($order_value);
					}elseif( in_array($field_type, ['checkbox']) ){
						$order_value = $order_value ? true : false;
					}else{
						$order_value = (string)$order_value;
					}

					if($order_value === '' or $order_value === null){
						continue;
					}

                    if( in_array($field_id, ['price', 'name', 'first_name', 'last_name']) ){
                        ${$entry}[$field_id] = $order_value;
                    }else{
                        ${$entry}['custom_fields_values'][] = [
                            'field_id' => (int)$field_id,
                            'values' => [
                                [
                                    'value' => $order_value
                                ]
                            ]
                        ];
                    }      
                }

				if( !is_array($order_info[$order_field]) ){
					$note_template = str_replace('{{'.$order_field.'}}', $order_info[$order_field], $note_template);
				}
            }

			if(isset($order_info['totals'])){
				$note_template .= PHP_EOL;
				foreach($order_info['totals'] as $total){
					$value = number_format($total['value'], 2, '.', '');
					$note_template .= $total['title'].': '.$value.' '.$order_info['currency_code'].PHP_EOL;
				}
			}

			if($settings['note_status'] and $settings['product_link'] and $order_info['products']){
				$note_template .= PHP_EOL;
				foreach($order_info['products'] as $product){
					$note_template .= $product['model'] . ' ' . $product['name'] .' x'.$product['quantity'].' https://'.$_SERVER['HTTP_HOST'].'/index.php?route=product/product&product_id='.$product['product_id'] . PHP_EOL;
					if(isset($product['option']) and $product['option']){
						$option_data = [];
						foreach($product['option'] as $option){
							$option_data[] = '- '.$option['name'].': '.$option['value']; 
						}
						$note_template .= implode(', ', $option_data).PHP_EOL.PHP_EOL;
					}
				}
			}

        }	
		
		if(isset($settings['amo_data']['utm_fields']) and isset($settings['amo_data']['utm_fields'])){
			$utms = $order_info['utm'];
			foreach($settings['amo_data']['utm_fields'] as $field_id => $utm){
				if(isset($utms[$utm])){
					$lead['custom_fields_values'][] = [
						'field_id' => (int)$field_id,
						'values' => [
							[
								'value' => (string)$utms[$utm]
							]
						]
					];
				}
			}
		}

		$tasks_data = isset($settings['tasks']) ? $settings['tasks'] : false;
		$tasks = [];
		if( $tasks_data ){
			$current_datetime = date('Y-m-d H:i:s');
			foreach($tasks_data as $task_data){
				$deadline = $task_data['deadline'] === '' ? 24 : $task_data['deadline'];
				$tasks[] = [
                    'responsible_user_id' => (int)$responsible_user_id,
                    'task_type_id' => (int)$task_data['type'],
                    'text' => (string)$task_data['text'],
                    'complete_till' => strtotime( $current_datetime . ' +' . $deadline . ' ' . $task_data['time'] )
				];
			}
		}

		$products = [];
		if(isset($order_info['products']) and (int)$settings['products']){
			$products = $order_info['products'];
		}else{
			$lead['price'] = (int)round($order_info['total']);
		}

		if( isset($contact) ){
			$contact['responsible_user_id'] = (int)$responsible_user_id;
		}else{
			$contact = [];
		}

		if( isset($company) ){
			$company['responsible_user_id'] = (int)$responsible_user_id;
		}else{
			$company = [];
		}

		$data = [
            'lead'     => isset($lead) ? $lead : [],
            'contact'  => $contact,
            'company'  => $company,
            'note'     => isset($note_template) ? $note_template : [],
            'tasks'    => $tasks,
			'products' => $products,
        ];

		if( isset($settings['antidub']) and (int)$settings['antidub'] ){
			$data['antidub'] = $settings['antidub'];
		}

        return json_encode($data);

    }

	private function get_responsible_user(){
		$settings = $this->config->get('module_amocrm_integration');
		if(!isset($settings['responsible_user_id'])){
			return 0;
		}
		$responsible_list = $settings['responsible_user_id'];
		$settings['current_responsible'] = isset($settings['current_responsible']) ? (int)$settings['current_responsible'] : 0;
		$settings['current_responsible']++;
		$settings['current_responsible'] = isset($responsible_list[($settings['current_responsible'])]) ? ($settings['current_responsible']) : 0;	
		$this->load->model('sale/amocrm_integration');
		$this->model_sale_amocrm_integration->saveSettings($settings);
		return (int)$responsible_list[($settings['current_responsible'])];

	}

	public function export(){
		if ( ($this->request->server['REQUEST_METHOD'] == 'POST' and $this->request->post['orders']) ) {
			$return = [];
			foreach($this->request->post['orders'] as $order_id){
				$curl = curl_init();
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($curl, CURLOPT_URL, 'https://functions.yandexcloud.net/d4ek9e15tnll0dcuakaq');
				curl_setopt($curl, CURLOPT_HEADER, false);
				curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'POST');
				curl_setopt($curl, CURLOPT_POSTFIELDS, http_build_query([
					'action' => 'newOrderV2', 
					'url' => $_SERVER['HTTP_HOST'], 
					'data' => $this->newOrder($order_id), 
					'order_id' => $order_id,
					'redirect' => 'https://devamo.ru/opencart/ajax'
				]));
				curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
				curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 2);
				$output = curl_exec($curl);
				curl_close($curl);
				$return[] = json_decode($output, true);
			}
			$this->response->addHeader('Content-Type: application/json');
			$this->response->setOutput( json_encode($return) );
		}
	}

	protected function validate() {
		if (!$this->user->hasPermission('modify', 'extension/module/amocrm_integration')) {
			$this->error['warning'] = $this->language->get('error_permission');
		}
		return !$this->error;
	}

	private function getAmoCF(){
		$lang = substr( $this->config->get('config_admin_language'), 0, 2);
		$ch = curl_init();
		curl_setopt($ch, CURLOPT_URL, 'https://functions.yandexcloud.net/d4ek9e15tnll0dcuakaq');
		curl_setopt($ch, CURLOPT_POST, 1);
		curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query([
			'action' => 'getAmoCF', 
			'url' => $_SERVER['HTTP_HOST'],
			'lang' => $lang,
			'redirect' => 'https://devamo.ru/opencart/ajax',
		])); 
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
		curl_setopt($ch, CURLOPT_HEADER, false);
		$output = curl_exec($ch);
		$output = json_decode($output, true);
		curl_close($ch);
		return isset($output['settings']) ? $output['settings'] : false;
	}

	private function getOrder($order_id){
		$this->load->model('sale/amocrm_integration');
		$order_utm = $this->model_sale_amocrm_integration->getUtmFromOrder($order_id);
		$order_info = $this->model_sale_amocrm_integration->getOrder($order_id);

		$data['order_id'] = $order_id;
		$data['store_id'] = $order_info['store_id'];
		$data['store_url'] = $_SERVER['HTTP_HOST'];

		$data['customer'] = $order_info['customer'];
		$data['customer_id'] = $order_info['customer_id'];
		$data['customer_group_id'] = $order_info['customer_group_id'];
		$data['firstname'] = $order_info['firstname'];
		$data['lastname'] = $order_info['lastname'];
		$data['email'] = $order_info['email'];
		$data['telephone'] = $order_info['telephone'];
		$data['fax'] = $order_info['fax'];
		$data['account_custom_field'] = $order_info['custom_field'];

		$data['addresses'] = $this->model_sale_amocrm_integration->getAddresses($order_info['customer_id']);

		$data['payment_firstname'] = $order_info['payment_firstname'];
		$data['payment_lastname'] = $order_info['payment_lastname'];
		$data['payment_company'] = $order_info['payment_company'];
		$data['payment_address_1'] = $order_info['payment_address_1'];
		$data['payment_address_2'] = $order_info['payment_address_2'];
		$data['payment_city'] = $order_info['payment_city'];
		$data['payment_postcode'] = $order_info['payment_postcode'];
		$data['payment_country_id'] = $order_info['payment_country_id'];
		$data['payment_country'] = $order_info['payment_country'];
		$data['payment_zone_id'] = $order_info['payment_zone_id'];
		$data['payment_zone'] = $order_info['payment_zone'];
		$data['payment_custom_field'] = $order_info['payment_custom_field'];
		$data['payment_method'] = $order_info['payment_method'];
		$data['payment_code'] = $order_info['payment_code'];

		$data['shipping_firstname'] = $order_info['shipping_firstname'];
		$data['shipping_lastname'] = $order_info['shipping_lastname'];
		$data['shipping_company'] = $order_info['shipping_company'];
		$data['shipping_address_1'] = $order_info['shipping_address_1'];
		$data['shipping_address_2'] = $order_info['shipping_address_2'];
		$data['shipping_city'] = $order_info['shipping_city'];
		$data['shipping_postcode'] = $order_info['shipping_postcode'];
		$data['shipping_country_id'] = $order_info['shipping_country_id'];
		$data['shipping_country'] = $order_info['shipping_country'];
		$data['shipping_zone'] = $order_info['shipping_zone'];
		$data['shipping_zone_id'] = $order_info['shipping_zone_id'];
		$data['shipping_custom_field'] = $order_info['shipping_custom_field'];
		$data['shipping_method'] = $order_info['shipping_method'];
		$data['shipping_code'] = $order_info['shipping_code'];
		$data['total'] = number_format($order_info['total'], 2, '.', '');	

		// Products
		$data['products'] = array();

		$products = $this->model_sale_amocrm_integration->getOrderProducts($order_id);

		foreach ($products as $product) {
			$data['products'][] = array(
				'product_id' => $product['product_id'],
				'name'       => $product['name'],
				'model'      => $product['model'],
				'option'     => $this->model_sale_amocrm_integration->getOrderOptions($order_id, $product['order_product_id']),
				'quantity'   => $product['quantity'],
				'price'      => number_format($product['price'], 2, '.', ''),
				'total'      => number_format($product['total'], 2, '.', ''),
				'reward'     => $product['reward']
			);
		}

		// Vouchers
		$data['order_vouchers'] = $this->model_sale_amocrm_integration->getOrderVouchers($order_id);

		$data['coupon'] = '';
		$data['voucher'] = '';
		$data['reward'] = '';

		$data['order_totals'] = array();

		$order_totals = $this->model_sale_amocrm_integration->getOrderTotals($order_id);

		foreach ($order_totals as $order_total) {
			// If coupon, voucher or reward points
			$start = strpos($order_total['title'], '(') + 1;
			$end = strrpos($order_total['title'], ')');

			if ($start && $end) {
				$data[$order_total['code']] = substr($order_total['title'], $start, $end - $start);
			}
		}

		$data['order_status_id'] = $order_info['order_status_id'];
		$data['comment'] = $order_info['comment'];
		$data['affiliate_id'] = $order_info['affiliate_id'];
		$data['affiliate'] = $order_info['affiliate_firstname'] . ' ' . $order_info['affiliate_lastname'];
		$data['currency_code'] = $order_info['currency_code'];
		$data['invoice_prefix'] = $order_info['invoice_prefix'];

		if ($order_info['invoice_no']) {
			$data['invoice_no'] = $order_info['invoice_prefix'] . $order_info['invoice_no'];
		} else {
			$data['invoice_no'] = '';
		}

		$totals = $this->model_sale_amocrm_integration->getOrderTotals($order_id);

		foreach ($totals as $total) {
			$data['totals'][] = $total;
		}

		$data['utm'] = $order_utm;
		$data['date_added'] = $order_info['date_added'];
		$data['date_modified'] = $order_info['date_modified'];
	
		$simple_fields = [];
		$orderSimpleFields = $this->model_sale_amocrm_integration->getOrderSimpleFields($order_id);
		if($orderSimpleFields){
			$keys = array_keys($orderSimpleFields);
			foreach($keys as $key){
				$simple_fields[$key] = $orderSimpleFields[$key];
			}
		}
		return array_merge($simple_fields, $data);
	}

	public function order(){
		if( $this->request->server['REQUEST_METHOD'] === 'POST' and $this->request->post['order_id'] ){
			$data = ['status' => 1, 'order' => $this->getOrder( $this->request->post['order_id'] )];
		}else{
			$data = ['status' => 0];
		}
		$this->response->addHeader('Content-Type: application/json');
		$this->response->setOutput( json_encode( $data ) );
	}

	public function install(){
		$this->load->model('sale/amocrm_integration');
		$this->load->model('setting/event');
		$this->load->model('setting/setting');
 		$this->model_setting_event->addEvent(
			'amoCRM-integration',
			'catalog/model/checkout/order/addOrderHistory/before',
			'api/amocrm_integration'
		);
		$this->model_setting_event->addEvent(
			'amoCRM-integration-newstore',
			'catalog/model/extension/module/newfastorder/addOrder/after',
			'api/amocrm_integration/newstore'
		);
		$this->model_setting_event->addEvent(
			'amoCRM-integration-bocorder',
			'catalog/model/checkout/bocorder/addBocorder/after',
			'api/amocrm_integration/newstore'
		);
		if($this->request->post['module_amocrm_integration']['amo_data'] = $this->getAmoCF() ){
			$this->model_setting_setting->editSetting('module_amocrm_integration', $this->request->post);
		}
		$this->model_sale_amocrm_integration->creatTableUtm();
	}

	public function uninstall() {
	    $this->load->model('sale/amocrm_integration');
		$this->load->model('setting/event');
		$this->load->model('setting/setting');
		$this->model_setting_event->deleteEventByCode('amoCRM-integration');
		$this->model_setting_event->deleteEventByCode('amoCRM-integration-addOrder');
		$this->model_setting_event->deleteEventByCode('amoCRM-integration-newstore');
		$this->model_setting_event->deleteEventByCode('amoCRM-integration-bocorder');
		$this->model_setting_setting->deleteSetting('module_amocrm_integration');
		$this->model_sale_amocrm_integration->deleteTableUtm();
	}
}